/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.packet;

import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import com.google.common.base.Preconditions;

public class MapContainer {
    private final FieldAccessor modCountField;
    private int lastModCount;
    private final Object source;
    private boolean changed;

    public MapContainer(Object source) {
        this.source = source;
        this.changed = false;
        this.modCountField = Accessors.getFieldAccessorOrNull(source.getClass(), "modCount", Integer.TYPE);
        Preconditions.checkNotNull((Object)this.modCountField, (Object)("unable to retrieve modCount field for " + String.valueOf(source.getClass())));
        this.lastModCount = this.getModificationCount();
    }

    public boolean hasChanged() {
        this.checkChanged();
        return this.changed;
    }

    public void setChanged(boolean changed) {
        this.changed = changed;
    }

    protected void checkChanged() {
        if (!this.changed && this.getModificationCount() != this.lastModCount) {
            this.lastModCount = this.getModificationCount();
            this.changed = true;
        }
    }

    private int getModificationCount() {
        return (Integer)this.modCountField.get(this.source);
    }
}

